import './example.scss'
import gsap from 'gsap'
import ScrollTrigger from 'gsap/ScrollTrigger'
import PhysicsPropsPlugin from 'gsap/PhysicsPropsPlugin'

const JS_HOOK_EXAMPLE = '[js-hook-example]'

// Register plugins like these
gsap.registerPlugin(PhysicsPropsPlugin, ScrollTrigger)

export class Example {
  element: HTMLElement
  isClicked: boolean = false
  clickTimeline?: gsap.core.Timeline
  hoverTimeline?: gsap.core.Timeline

  constructor(element: HTMLElement) {
    this.element = element

    this.#setupTimelines()
    this.#bindEvents()
  }

  #bindEvents() {
    this.element.addEventListener('click', () => this.#handleClick())
    this.element.addEventListener('mouseenter', () => this.#handleMouseEnter())
    this.element.addEventListener('mouseleave', () => this.#handleMouseLeave())
  }

  #setupTimelines() {
    this.clickTimeline = gsap.timeline({ paused: true }).fromTo(
      this.element,
      { rotate: 0, borderRadius: '5%', ease: 'elastic.out(2,0.5)' },
      {
        rotate: 135,
        borderRadius: '50%',
        ease: 'elastic.inOut(1,0.3)',
        duration: 1,
      },
    )

    this.hoverTimeline = gsap.timeline({ paused: true }).fromTo(
      this.element,
      { scale: 1 },
      {
        scale: 'random([1.2, 1.4])',
        duration: 0.5,
        ease: 'elastic.out(2,0.3)',
      },
    )
  }

  #handleClick() {
    this.isClicked = !this.isClicked

    this.clickTimeline?.[this.isClicked ? 'play' : 'reverse']()
  }

  #handleMouseEnter() {
    this.hoverTimeline?.play()
  }

  #handleMouseLeave() {
    this.hoverTimeline?.reverse()
  }
}

const element: HTMLElement | null = document.querySelector(JS_HOOK_EXAMPLE)

if (element) new Example(element)
